<?php
function connect_database()
{
    $servername = "localhost";
    $username = "admin";
    $password = "admin";
    $database = "clever-report";

    $conn = new mysqli($servername, $username, $password, $database);

    if ($conn->connect_error) {
        die("Connection failed: " . $conn->connect_error);
    }
    return $conn;
}

function fetch_reports()
{
    $conn = connect_database();
    $sql = "SELECT * FROM reportInfo;";
    $result = $conn->query($sql);
    if ($result->num_rows > 0) {
        while ($row = mysqli_fetch_all($result, MYSQLI_ASSOC)) {
            $data = $row;
        }
    } else {
        echo "No results";
    }
    $conn->close();
    return $data;
}

function fetch_avliable_reports()
{
    $conn = connect_database();
    $sql = "SHOW TABLES";
    $result = $conn->query($sql);
    if ($result->num_rows > 0) {
        while ($row = mysqli_fetch_all($result)) {
            $data = $row;
        }
    } else {
        echo "No results";
    }
    $conn->close();
    return $data;
}

function fetch_caste()
{
    $conn = connect_database();
    $sql = "SELECT caste FROM trends WHERE caste IS NOT NULL";
    $result = $conn->query($sql);
    if ($result->num_rows > 0) {
        while ($row = mysqli_fetch_all($result, MYSQLI_ASSOC)) {
            $data = $row;
        }
    } else {
        echo "No results";
    }
    $conn->close();
    return $data;
}

function get_caste_data($caste, $id){
    $conn = connect_database();
    $sql = "SELECT adjusted_INC, adjusted_BJP, adjusted_AAP, adjusted_Others from trends WHERE caste = '" .$caste. "' AND report_id=".$id;
    $result = $conn->query($sql);
    if ($result->num_rows > 0) {
        while ($row = mysqli_fetch_all($result, MYSQLI_ASSOC)) {
            $data = $row;
        }
    }
    $conn->close();
    return $data[0];
}

function update_caste_values($newData)
{
    $conn = connect_database();
    $id = $_GET['id'];
    $oldData = get_caste_data($newData['caste'], $id);
    $inc = $oldData['adjusted_INC'] + $newData['INC'];
    $bjp = $oldData['adjusted_BJP'] + $newData['BJP'];
    $aap = $oldData['adjusted_AAP'] + $newData['AAP'];
    $others = $oldData['adjusted_Others'] + $newData['Others'];
    $sql = "UPDATE `trends` SET `adjusted_INC`= ".$inc.",`adjusted_BJP`= ".$bjp.",`adjusted_AAP`= ".$aap.",`adjusted_Others`= ".$others." WHERE caste = '" .$newData['caste']. "' AND report_id=".$id;
    print_r($sql);
    $conn->query($sql);
    $conn->close();
}

function find_already_added_table()
{
    $conn = connect_database();
    $sql = "SELECT `report_tablename` FROM `reportInfo`;";
    $result = $conn->query($sql);
    if ($result->num_rows > 0) {
        while ($row = mysqli_fetch_all($result)) {
            $data = $row;
        }
    } else {
        echo "No results";
    }
    $conn->close();
    return $data[0];
}

function insert_values($id, $tableName)
{
    $conn = connect_database();
    $data1 = get_data_trends($tableName, $conn);
    insert_trends($id, $data1, $conn);
    $data2 = get_data_inclination($tableName, $conn);
    insert_inclination($id, $data2, $conn);
    $data3 = get_data_ratings($tableName, $conn);
    insert_ratings($id, $data3, $conn);

    return null;
}

function get_data_trends($tableName, $db)
{
    if (empty($db)) {
        $msg = "Database is empty";
    } elseif (empty($tableName)) {
        $msg = "Table Name is empty";
    } else {
        $arr = ['CasteGroups', 'Occupation', 'Age', 'Education'];
        $sendData = [];
        foreach ($arr as $field) {

            if ($field === 'CasteGroups' || $field === 'Occupation' || $field === 'Education') {
                $query = '
                SELECT
                s.`' . $field . '`, MAX(s.assembly_id) as assembly_id,
                ROUND((SELECT COUNT(*) FROM `' . $tableName . '` t WHERE Q4 = "कोंग्रेस (INC)" AND s.`' . $field . '` = t.`' . $field . '`) * 100.0/ COUNT(*), 1) as INC,
                ROUND((SELECT COUNT(*) FROM `' . $tableName . '` t WHERE Q4 = "भाजपा (BJP)" AND s.`' . $field . '` = t.`' . $field . '`) * 100.0/ COUNT(*), 1) as BJP,
                ROUND((SELECT COUNT(*) FROM `' . $tableName . '` t WHERE Q4 = "आप (AAP)" AND s.`' . $field . '` = t.`' . $field . '`) * 100.0/ COUNT(*), 1) as AAP,
                ROUND(((SELECT COUNT(*) FROM `' . $tableName . '` t WHERE Q4 != "कोंग्रेस (INC)" AND Q4 != "भाजपा (BJP)" AND Q4 != "आप (AAP)" AND s.`' . $field . '` = t.`' . $field . '`)) * 100.0/ COUNT(*), 1) as Others
                FROM `' . $tableName . '` s 
                GROUP BY s.`' . $field . '`
                ORDER BY COUNT(s.`' . $field . '`) DESC
                ;
                ';
            } elseif ($field === 'Age') {
                $query = '
                SELECT
                MAX(s.assembly_id) as assembly_id,
                CASE
                WHEN s.`' . $field . '` between 18 and 22 THEN "18-22"
                WHEN s.`' . $field . '` between 23 and 30 THEN "23-30"
                WHEN s.`' . $field . '` between 31 and 45 THEN "31-45"
                WHEN s.`' . $field . '` between 46 and 60 THEN "46-60"
                WHEN s.`' . $field . '` between 61 and 99 THEN "61-99"
                END as AgeGroup,
                COUNT(s.`' . $field . '`) as totalNumberOfParticipaton,
                ROUND((SELECT COUNT(*) FROM `' . $tableName . '` t WHERE Q4 = "कोंग्रेस (INC)" AND (t.`' . $field . '` BETWEEN LEFT(AgeGroup, 2) AND RIGHT(AgeGroup, 2) ) ) * 100.00 / COUNT(*), 1) as INC,
                ROUND((SELECT COUNT(*) FROM `' . $tableName . '` t WHERE Q4 = "भाजपा (BJP)" AND (t.`' . $field . '` BETWEEN LEFT(AgeGroup, 2) AND RIGHT(AgeGroup, 2) ) ) * 100.00 / COUNT(*), 1) as BJP,
                ROUND((SELECT COUNT(*) FROM `' . $tableName . '` t WHERE Q4 = "आप (AAP)" AND (t.`' . $field . '` BETWEEN LEFT(AgeGroup, 2) AND RIGHT(AgeGroup, 2) ) ) * 100.00 / COUNT(*), 1) as AAP,
                ROUND((SELECT COUNT(*) FROM `' . $tableName . '` t WHERE Q4 != "कोंग्रेस (INC)" AND Q4 != "भाजपा (BJP)" AND Q4 != "आप (AAP)" AND (t.`' . $field . '` BETWEEN LEFT(AgeGroup, 2) AND RIGHT(AgeGroup, 2) ) ) * 100.00 / COUNT(*), 1) as Others
                FROM `' . $tableName . '` s 
                GROUP BY AgeGroup
                ORDER BY AgeGroup
                ;
                ';
            }
            $result = $db->query($query);
            if ($result == true) {
                if ($result->num_rows > 0) {
                    $row = mysqli_fetch_all($result, MYSQLI_ASSOC);
                    $msg = $row;
                } else {
                    $msg = "No Data Found";
                }
            } else {
                $msg = mysqli_error($db);
            }
            array_push($sendData, $msg);
        }
    }
    return $sendData;
}

function insert_trends($id, $data, $conn)
{
    $arr = ['caste', 'occupation', 'age_group', 'education'];
    $arr2 = ['CasteGroups', 'Occupation', 'AgeGroup', 'Education'];
    foreach ($arr as $key => $col) {
        $sql = "INSERT INTO `trends`
        (`assembly_id`, `report_id`, `" . $col . "`, `INC`, `BJP`, `AAP`, `Others`, `adjusted_INC`, `adjusted_BJP`, `adjusted_AAP`, `adjusted_Others`) VALUES 
        ";
        $flag = true;
        foreach ($data[$key] as $inputdata => $row) {
            $temp = $row[$arr2[$key]];
            $val = "('" . $row['assembly_id'] . "','" . $id . "','" . $temp . "','" . $row['INC'] . "','" . $row['BJP'] . "','" . $row['AAP'] . "','" . $row['Others'] . "','" . $row['INC'] . "','" . $row['BJP'] . "','" . $row['AAP'] . "','" . $row['Others'] . "')";
            if ($flag)
                $sql = $sql  . $val;
            else
                $sql = $sql . ', ' . $val;

            $flag = false;
        }
        $conn->query($sql);
        $conn->close();
    }
}

function get_data_inclination($tableName, $db)
{
    if (empty($db)) {
        $msg = "Database is empty";
    } elseif (empty($tableName)) {
        $msg = "Table Name is empty";
    } else {
        $query = '
            SELECT
            MAX(s.assembly_id) as assembly_id,
            ROUND((SELECT COUNT(*) FROM `' . $tableName . '` t WHERE Q4 = "कोंग्रेस (INC)") * 100.0/ COUNT(*), 1) as INC,
            ROUND((SELECT COUNT(*) FROM `' . $tableName . '` t WHERE Q4 = "भाजपा (BJP)") * 100.0/ COUNT(*), 1) as BJP,
            ROUND((SELECT COUNT(*) FROM `' . $tableName . '` t WHERE Q4 = "आप (AAP)") * 100.0/ COUNT(*), 1) as AAP,
            ROUND(((SELECT COUNT(*) FROM `' . $tableName . '` t WHERE Q4 != "कोंग्रेस (INC)" AND Q4 != "भाजपा (BJP)" AND Q4 != "आप (AAP)")) * 100.0/ COUNT(*), 1) as Others
            FROM `' . $tableName . '` s 
            ;
        ';
        $result = $db->query($query);
        if ($result == true) {
            if ($result->num_rows > 0) {
                $row = mysqli_fetch_all($result, MYSQLI_ASSOC);
                $msg = $row;
            } else {
                $msg = "No Data Found";
            }
        } else {
            $msg = mysqli_error($db);
        }
    }
    return $msg[0];
}

function insert_inclination($id, $data, $conn)
{
    $sql = "INSERT INTO `inclination`(`assembly_id`, `report_id`, `INC`, `BJP`, `AAP`, `Others`, `adjusted_INC`, `adjusted_BJP`, `adjusted_AAP`, `adjusted_Others`) 
    VALUES ('" . $data['assembly_id'] . "','" . $id . "','" . $data['INC'] . "','" . $data['BJP'] . "','" . $data['AAP'] . "','" . $data['Others'] . "','" . $data['INC'] . "','" . $data['BJP'] . "','" . $data['AAP'] . "','" . $data['Others'] . "')";
    echo $sql;
    $conn->query($sql);
    $conn->close();
}

function get_data_ratings($tableName, $db)
{
    if (empty($db)) {
        $msg = "Database is empty";
    } elseif (empty($tableName)) {
        $msg = "Table Name is empty";
    } else {
        $arr = ['Q1', 'Q2', 'Q3'];
        $sendData = [];
        foreach ($arr as $field) {
            $query = '
                SELECT s.`' . $field . '`, MAX(s.assembly_id) as assembly_id, ABS(LEFT(RIGHT(s.`' . $field . '`,3),2)) as orderBy, 
                ROUND(((COUNT(*) *100.00)/(SELECT COUNT(*) FROM `' . $tableName . '`)), 1) as totalPercentage,
                (SELECT COUNT(`' . $field . '`) FROM `' . $tableName . '`t WHERE t.`' . $field . '` = s.`' . $field . '`) as total
                FROM `' . $tableName . '` s 
                GROUP BY s.`' . $field . '` 
                ORDER BY orderBy DESC
                ;
                ';
            $result = $db->query($query);
            if ($result == true) {
                if ($result->num_rows > 0) {
                    $row = mysqli_fetch_all($result, MYSQLI_ASSOC);
                    $msg = $row;
                } else {
                    $msg = "No Data Found";
                }
            } else {
                $msg = mysqli_error($db);
            }
            array_push($sendData, $msg);
        }
    }
    return $sendData;
}


function insert_ratings($id, $data, $conn)
{
    $arr = ['Q1', 'Q2', 'Q3'];
    foreach ($arr as $key => $col) {
        $sql = "INSERT INTO `ratings`
        (`assembly_id`, `report_id`, `question`, `rating`, `total_votes`, `total_percentage`, `adjusted_total_votes`, `adjusted_total_percentage`) VALUES 
        ";
        $flag = true;
        foreach ($data[$key] as $inputdata => $row) {
            $val = "('" . $row['assembly_id'] . "','" . $id . "','" . $col . "','" . $row[$col] . "','" . $row['total'] . "','" . $row['totalPercentage'] . "','" . $row['total'] . "','" . $row['totalPercentage'] . "')";
            if ($flag)
                $sql = $sql  . $val;
            else
                $sql = $sql . ', ' . $val;

            $flag = false;
        }
        print_r($sql);
        $conn->query($sql);
        $conn->close();
    }
}
