<!DOCTYPE html>
<html>

<head>
  <title>Polytical Edge | Manage Income</title>
  <?php include 'css.php';
  include './assets/database/fetch.php'; ?>
</head>

<body>
  <div class="main-wrapper">
    <?php $currentPage = 'data-table';
    include 'sidebar.php'; ?>
    <div class="page-wrapper">
      <?php include 'header.php'; ?>
      <div class="page-content">
        <div class="row">
          <div class="col-md-12 grid-margin stretch-card">
            <div class="card add-row">
              <div class="card-body">
                <h6 class="card-title">View Reports</h6>
                <div class="col-lg-12 p-4" style="border:1px solid grey; border-radius:10px">
                  <h6>Adjust Values</h6>
                  <div class="dropdown show col-lg-12 d-flex justify-content-center">
                    <div class="btn-group btn-group-toggle" data-toggle="buttons">
                      <label class="btn btn-outline-info active">
                        <input type="radio" name="caste" id="caste" autocomplete="off" checked> Caste
                      </label>
                      <label class="btn btn-outline-info">
                        <input type="radio" name="occupation" id="occupation" autocomplete="off"> Occupation
                      </label>
                      <label class="btn btn-outline-info">
                        <input type="radio" name="agegroup" id="agegroup" autocomplete="off"> Age Group
                      </label>
                      <label class="btn btn-outline-info">
                        <input type="radio" name="education" id="education" autocomplete="off"> Education
                      </label>
                    </div>
                  </div>
                  <div class="col-lg-12 pt-5">
                    <form action="./view-report.php?id=<?= $_GET['id'] ?>" method="POST">
                      <div class="row">
                        <div class="col">
                          <label for="select_adjustment">Select Caste</label>
                          <select class="btn-outline-info" name="select_adjustment" id="select_adjustment">
                            <?php
                            $caste_data = fetch_caste();
                            foreach ($caste_data as $key => $caste) {
                              echo '<option value="' . $caste['caste'] . '">' . $caste['caste'] . '</option>';
                            }
                            ?>
                          </select>
                        </div>
                        <div class="col">
                          <label for="select_adjustment_INC">INC</label>
                          <input class="form-control report-input" type="number" max="100" id="select_adjustment_INC" placeholder="0.00%" name="select_adjustment_INC">
                          <div class="invalid-feedback">
                            The total sum should be 0.
                          </div>
                        </div>
                        <div class="col">
                          <label for="select_adjustment_BJP">BJP</label>
                          <input class="form-control report-input" type="number" max="100" id="select_adjustment_BJP" placeholder="0.00%" name="select_adjustment_BJP">
                          <div class="invalid-feedback">
                            The total sum should be 0.
                          </div>
                        </div>
                        <div class="col">
                          <label for="select_adjustment_AAP">AAP</label>
                          <input class="form-control report-input" type="number" max="100" id="select_adjustment_AAP" placeholder="0.00%" name="select_adjustment_AAP">
                          <div class="invalid-feedback">
                            The total sum should be 0.
                          </div>
                        </div>
                        <div class="col">
                          <label for="select_adjustment_Others">Others</label>
                          <input class="form-control report-input" type="number" max="100" id="select_adjustment_Others" placeholder="0.00%" name="select_adjustment_Others">
                          <div class="invalid-feedback">
                            The total sum should be 0.
                          </div>
                        </div>
                        <div class="col">
                          <label for="select_adjustment_button" id="select_adjustment_button_lable">Total: 0</label>
                          <input class="form-control btn btn-outline-info" name="submit" type="submit" value="Submit Report" id="report_submit">
                        </div>
                      </div>
                    </form>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
      <?php include 'footer.php'; ?>
      <?php include 'js.php'; ?>
    </div>
  </div>
  <script>
    $('#report_submit').on('click', () => {
      var total = parseFloat(document.getElementById("select_adjustment_INC").value) + parseFloat(document.getElementById("select_adjustment_BJP").value) + parseFloat(document.getElementById("select_adjustment_AAP").value) + parseFloat(document.getElementById("select_adjustment_Others").value);
      if (total != 0) {
        event.preventDefault();
        $(".report-input").addClass("is-invalid");
        $(".report-input").removeClass("is-valid");
      } else {
        $(".report-input").removeClass("is-invalid");
        $(".report-input").addClass("is-valid");
      }
    });
    $('.report-input').change(() => {
      var total = parseFloat(document.getElementById("select_adjustment_INC").value) + parseFloat(document.getElementById("select_adjustment_BJP").value) + parseFloat(document.getElementById("select_adjustment_AAP").value) + parseFloat(document.getElementById("select_adjustment_Others").value);
      document.getElementById('select_adjustment_button_lable').innerHTML = `Total: ${total}`;
    });
  </script>
  <?php
  if (isset($_POST['submit'])) {
    $updateData = [
      'caste' => $_POST["select_adjustment"],
      'INC' => $_POST["select_adjustment_INC"] == '' ? 0 : $_POST["select_adjustment_INC"],
      'BJP' => $_POST["select_adjustment_BJP"] == '' ? 0 : $_POST["select_adjustment_BJP"],
      'AAP' => $_POST["select_adjustment_AAP"] == '' ? 0 : $_POST["select_adjustment_AAP"],
      'Others' => $_POST["select_adjustment_Others"] == '' ? 0 : $_POST["select_adjustment_Others"]
    ];
    update_caste_values($updateData);
    echo '<script>alert("Value Updated");</script>';
  }
  ?>
</body>

</html>