<?php
session_start();
?>
<!DOCTYPE html>
<html>

<head>
    <title>Polytical Edge | Add Bulk Report</title>
    <?php include 'css.php';
	include './assets/database/fetch.php'; ?>
</head>

<body>
    <div class="round-loader d-none">
        <div class="circle"></div>
    </div>
    <div class="main-wrapper">
        <?php $currentPage = 'basic-element';
		include 'sidebar.php';
		?>
        <div class="page-wrapper">
            <?php include 'header.php'; ?>
            <div class="page-content">
                <div class="row">
                    <div class="col-md-12 grid-margin stretch-card">
                        <div class="card add-row">
                            <div class="card-body">
                                <h6 class="card-title">Add Bulk Report
                                </h6>
                                <form class="forms-sample" action="" method="POST">
                                    <div class="form-group col-md-12">
                                        <ul class="list-group">
                                            <?php
											$data = fetch_bulk_report();
											foreach ($data as $key => $assembly) {
												echo '
													<ul class="col-md-6 m-2 d-flex align-items-center">
														<li class="rounded-0 col-md-6 list-group-item list-group-item-action d-flex justify-content-between align-items-center">
															' . $assembly["Assembly_Name"] . ' (' . $assembly["assembly_id"] . ')
															<span class="badge badge-primary badge-pill">' . $assembly["total"] . '</span>
														</li>
														<li class="p-0 d-flex align-items-center">
															<button type="submit" name="submit" id="submit-' . $assembly["assembly_id"] . '" class="rounded-0 p-3 btn btn-outline-primary add-bulk-report-submit">Genrate report</button>
															<input class="assembly_id" type="number" name="assembly_id" id="submit-' . $assembly["assembly_id"] . '" value="' . $assembly["assembly_id"] . '" hidden>
															</li>
															</ul>
															';
											} ?>
                                        </ul>
                                        <?php
										if($data){
											echo '<button type="submit" name="submit_all" id="submit_all" class="mt-2 btn btn-outline-primary add-bulk-report-submit">Genrate all report</button>';
										}
										?>
                                        </select>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php include 'footer.php'; ?>
            <?php include 'js.php'; ?>
        </div>
    </div>
    <script>
    $(' .add-bulk-report-submit').click(() => {
        $('.circle').addClass('animate_rotate');
        $('.round-loader').removeClass('d-none');
        setTimeout(
            () => {
                $('.circle').removeClass('animate_rotate');
                $('.round-loader').addClass('d-none');
            }, 5000);
    })
    </script>
    <?php
	if (isset($_POST["submit"])) {
		insert_bulk($_POST["assembly_id"]);
		echo "<script>document.location = 'add-bulk-report.php';</script>";
	}
	if (isset($_POST["submit_all"])) {
		insert_bulk(-1);
		echo "<script>document.location = 'add-bulk-report.php';</script>";
	}
	?>
</body>

</html>