<?php
session_start();
?>
<!DOCTYPE html>
<html>

<head>
    <title>Polytical Edge | Add Report</title>
    <?php include 'css.php';
	include './assets/database/fetch.php'; ?>
</head>

<body>
    <div class="main-wrapper">
        <?php $currentPage = 'basic-element';
		include 'sidebar.php'; ?>
        <div class="page-wrapper">
            <?php include 'header.php'; ?>
            <div class="page-content">
                <div class="row">
                    <div class="col-md-12 grid-margin stretch-card">
                        <div class="card add-row">
                            <div class="card-body">
                                <h6 class="card-title">Add Report
                                </h6>
                                <form class="forms-sample" action="" method="POST">
                                    <div class="form-group">
                                        <label for="report-select">Select Source Table*</label>
                                        <select class="form-control" name="report_select" id="report-select" required>
                                            <option selected disabled>Select your Report</option>
                                            <?php
											$data = fetch_available_reports();
											$notIncludedTables1 = fetch_already_added_table();
											$notIncludedTables = array_merge($notIncludedTables1, ['trends', 'ratings', 'reportInfo', 'inclination', 'Role', 'User', 'bulkReport', 'party_colours', 'caste_dynamics', 'past_results']);
											foreach ($data as $key => $value) {
												if (!in_array($value[0], $notIncludedTables)) {
													echo "<option value='" . $value[0] . "'>" . $value[0] . "</option>";
												}
											}
											?>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="report-title">Report Title*</label>
                                        <input type="text" name="report_title" class="form-control" id="report-title"
                                            Placeholder="Enter Report Title" required>
                                    </div>
                                    <div class="form-group">
                                        <label for="assembly_id">Assembly ID*</label>
                                        <input type="number" name="assembly_id" class="form-control" id="assembly_id"
                                            Placeholder="Enter Assembly ID" required>
                                    </div>
                                    <div class="form-group">
                                        <label for="lok-sabha">Loksabha</label>
                                        <input type="text" name="lok_sabha" class="form-control" id="lok-sabha"
                                            Placeholder="Enter Loksabha">
                                    </div>
                                    <div class="form-group">
                                        <label for="district">District</label>
                                        <input type="text" name="district" class="form-control" id="district"
                                            Placeholder="Enter District">
                                    </div>
                                    <div class="form-group">
                                        <label for="mla-name">MLA Name</label>
                                        <input type="text" name="mla_name" class="form-control" id="mla-name"
                                            Placeholder="Enter MLA Name">
                                    </div>
                                    <div class="form-group">
                                        <label for="Rating-Comment">Rating Comment</label>
                                        <div class="form-control" id="Rating-Comment"></div>
                                        <input type="text" name="rating_comment" id="rating_comment_input"
                                            class="form-control" hidden>
                                    </div>
                                    <div class="form-group">
                                        <label for="Factors">Inclination - Factors</label>
                                        <div class="form-control" id="Factors">
                                            <input type="text" name="factors" id="factors_input" class="form-control"
                                                hidden>
                                        </div>
                                        <div class="form-group mt-3">
                                            <label for="Qualitatve">Inclination - Qualitative</label>
                                            <div class="form-control" id="Qualitatve">
                                            </div>
                                            <input type="text" name="qualitatve" id="qualitatve_input"
                                                class="form-control" hidden>
                                            <button type="submit" name="submit" id=submit
                                                class="btn btn-primary mt-3">Submit</button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php include 'footer.php'; ?>
            <?php include 'js.php'; ?>
        </div>
    </div>
    <script>
    var get_data_rating;
    var get_data_factors;
    var get_data_qualitative;
    ClassicEditor
        .create(document.querySelector('#Rating-Comment'))
        .then(rating => {
            rating.model.document.on('change:data', () => {
                var data = rating.getData();
                $('#rating_comment_input').val(data);
                get_data_rating = data;
            });
        })
        .catch(error => {
            console.error(error);
        });
    ClassicEditor
        .create(document.querySelector('#Factors'))
        .then(factors => {
            factors.model.document.on('change:data', () => {
                var data = factors.getData();
                $('#factors_input').val(data);
                get_data_factors = data;
            });
        })
        .catch(error => {
            console.error(error);
        });
    ClassicEditor
        .create(document.querySelector('#Qualitatve'))
        .then(qualitative => {
            qualitative.model.document.on('change:data', () => {
                var data = qualitative.getData();
                $('#qualitatve_input').val(data);
                get_data_qualitative = data;
            });
        })
        .catch(error => {
            console.error(error);
        });
    $('#submit').on('click', () => {
        $('#rating_comment_input').val(get_data_rating);
        $('#factors_input').val(get_data_factors);
        $('#qualitatve_input').val(get_data_qualitative);
    });
    </script>
    <?php
	// get_data_ratings('ganganagar', $conn);
	if (isset($_POST["submit"])) {
		$conn = connect_database();
		$report_title = $_POST["report_title"];
		$tablename = $_POST["report_select"];
		$loksabha = $_POST["lok_sabha"];
		$district = $_POST["district"];
		$mla_name = $_POST["mla_name"];
		$rating_comment = $_POST["rating_comment"];
		$factors = $_POST["factors"];
		$qualitatve = $_POST["qualitatve"];
		$id = $_POST["assembly_id"];
		$sql = "INSERT INTO `reportInfo`(`assembly_id`, `report_title`, `report_tablename`, `mla_name`, `rating_comment`, `inclination_factors`, `inclination_qualitative`,`loksabha`,`district`) VALUES ('" . $id . "','" . $report_title . "','" . $tablename . "','" . $mla_name . "','" . $rating_comment . "','" . $factors . "','" . $qualitatve . "','" . $loksabha . "','" . $district . "')";
		$conn->query($sql);
		insert_report($id,$tablename);
		$conn->close();
	}
	?>
</body>

</html>