function downloadPDFreport(filename, elementID) {
    $('table').removeClass('dataTable');
    $('.dataTables_length').hide();
    $('.dataTables_filter').hide();
    $('.dataTables_info').hide();
    $('.dataTables_paginate').hide();
    $('#print-report-container').addClass('active');
    $('.report-section').addClass('active');
    $('.trends_data_table').addClass('active');
    $('.table-scroll').addClass('active');

    var HTML_Width = $("#" + elementID).width();
    var HTML_Height = $("#" + elementID).height();
    var top_left_margin = 0;
    // var top_left_margin = 15;
    var PDF_Width = HTML_Width + (top_left_margin * 2);
    var PDF_Height = (PDF_Width * 1.5) + (top_left_margin * 2);
    var canvas_image_width = HTML_Width;
    var canvas_image_height = HTML_Height;

    var totalPDFPages = Math.ceil(HTML_Height / PDF_Height) - 1;

    html2canvas($("#" + elementID)[0]).then(function(canvas) {
        var imgData = canvas.toDataURL("image/jpeg", 1.0);
        var pdf = new jsPDF('l', 'px', [PDF_Height, PDF_Width]);
        pdf.addImage(imgData, 'JPG', top_left_margin, top_left_margin, canvas_image_width, canvas_image_height);
        for (var i = 1; i <= totalPDFPages; i++) {
            pdf.addPage(PDF_Width, PDF_Height);
            pdf.addImage(imgData, 'JPG', top_left_margin, -(PDF_Height * i) + (top_left_margin * 4), canvas_image_width, canvas_image_height);
        }
        pdf.save(filename + ".pdf");
        // $("#print-report-container").hide();
    });

    $('table').addClass('dataTable');
    $('.dataTables_length').show();
    $('.dataTables_filter').show();
    $('.dataTables_info').show();
    $('.dataTables_paginate').show();
    $('#print-report-container').removeClass('active');
    $('.report-section').removeClass('active');
    $('.trends_data_table').removeClass('active');
    $('.table-scroll').removeClass('active');

}


function downloadDOCreport(element, filename) {
    // var elHtml = document.getElementById(elementID).innerHTML;
    // var link = document.createElement('a');
    // link.setAttribute('download', filename + '.doc');
    // link.setAttribute('href', 'data:' + 'text/doc' + ';charset=utf-8,' + encodeURIComponent(elHtml));
    // link.click();

    var preHtml = "<html xmlns:o='urn:schemas-microsoft-com:office:office' xmlns:w='urn:schemas-microsoft-com:office:word' xmlns='http://www.w3.org/TR/REC-html40'><head><meta charset='utf-8'><title>Export HTML To Doc</title></head><body>";
    var postHtml = "</body></html>";

    var content = document.getElementById(element).innerHTML;

    var html = preHtml + content + postHtml;

    var blob = new Blob(['\ufeff', html], {
        type: 'application/msword'
    });

    // Specify link url
    var url = 'data:application/vnd.ms-word;charset=utf-8,' + encodeURIComponent(html);

    // Specify file name
    filename = filename ? filename + '.docx' : 'document.docx';

    // Create download link element
    var downloadLink = document.createElement("a");

    document.body.appendChild(downloadLink);

    if (navigator.msSaveOrOpenBlob) {
        navigator.msSaveOrOpenBlob(blob, filename);
    } else {
        // Create a link to the file
        downloadLink.href = url;

        // Setting the file name
        downloadLink.download = filename;

        //triggering the function
        downloadLink.click();
    }

    document.body.removeChild(downloadLink);
}