<?php
session_start();
ini_set('display_errors', '1');
ini_set('display_startup_errors', '1');
error_reporting(E_ALL);
?>
<!DOCTYPE html>
<html>

<head>
    <title>Polytical Edge | View Report</title>
    <?php include 'css.php';
    // error_reporting(E_ALL);
    
  include './assets/database/fetch.php';
  $id = $_GET['id'];
  $fetchReportData = get_assembly_detail($id);
  $fetchReportInfo = fetch_report_info($id);
  $fetchData = fetch_trends_data($id);
  $election_type = fetch_past_result($id);
  $caste_dynamics_data = fetch_cast_dynamics($id);
  ?>
</head>

<body>
    <div class="main-wrapper">
        <?php $currentPage = 'data-table';
        include 'sidebar.php'; 
        include 'header.php'; ?>
        <div class="page-wrapper">
            <div class="page-content">
                <div class="row">
                    <div class="col-md-12  grid-margin stretch-card hidden-in-print">
                        <div class="card add-row">
                            <div class="card-body print-section">
                                <div class="col-lg-12 p-4 d-flex justify-content-between">
                                    <div class="dropdown show d-flex justify-content-center align-items-center w-100">
                                        <div class="btn-group btn-group-toggle">
                                            <!-- onclick='downloadPDFreport("report","print-report-container")' -->
                                            <input type="button" value="Download PDF"
                                                onclick="window.print();return false;" id="pdf_download_button"
                                                class="col col-lg-12 col-md-12 col-sm-12 col-12 btn btn-outline-info d-flex justify-content-center align-items-center">
                                            <input type="button" value="Download Doc"
                                                onclick='downloadDOCreport("print-report-container","report")'
                                                id="doc_download_button"
                                                class="col col-lg-12 col-md-12 col-sm-12 col-12 btn btn-outline-info d-flex justify-content-center align-items-center">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div id='print-report-container' class="print p-0">

                        <!-- starting page container -->
                        <div class="overflow-auto report-section starting_page_results_data_table col-md-12 p-0">
                            <div class="grid-margin stretch-card">
                                <div class="card add-row">
                                    <div class="card-body print-section p-0">
                                        <div class="col-lg-12 p-0" style="border-radius:10px;">
                                            <div class="d-flex flex-column justify-content-center align-items-center">
                                                <img src="./assets/images/report-img.png" alt="">
                                                <h1 class="mt-5 mb-2"
                                                    style="text-transform: uppercase; font-weight:800;">KEY INSIGHTS
                                                    FOR <?=$fetchReportData['title']?> (<?=$fetchReportData['id']?>)
                                                </h1>
                                                <h1 class="mt-5 mb-2"><b style="color:#C50E00">Political</b>EDGE</h1>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- past result container -->
                        <?php 
                        if (count($election_type) > 0) {
                            ?>
                        <div class="overflow-auto report-section past_results_data_table col-md-12">
                            <div class="grid-margin stretch-card">
                                <div class="card add-row">
                                    <div class="card-body print-section">
                                        <h6 class="card-title">Past Results</h6>
                                        <div class="col-lg-12" style="border-radius:10px;">
                                            <div class="table-scroll">
                                                <?php
                          foreach ($election_type as $electionType => $allYear) {
                            foreach ($allYear as $year => $fetchPastResultData) {
                              
                          ?>

                                                <table id='dataTable_<?=$year?>_<?=$electionType?>' cellspacing="0"
                                                    class='display dataTable  past_results_table table is-striped table-striped'>
                                                    <thead>
                                                        <tr>
                                                            <th colspan="4"></th>
                                                        </tr>
                                                        <tr>
                                                            <th colspan="4">
                                                                <center><b><?=$year?> <?=$electionType?> Election</b>
                                                                </center>
                                                            </th>
                                                        </tr>
                                                        <tr>
                                                            <th>Name</th>
                                                            <th>Party</th>
                                                            <th>Votes</th>
                                                            <th>Percent</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <?php
                                  if (is_array($fetchPastResultData)) {
                                    $polled_votes = 0;
                                    $polling = 0;
                                    foreach ($fetchPastResultData as $data) {
                                      $polled_votes += (int)$data['votes'];
                                      $polling += (float)$data['percent'];
                                  ?>
                                                        <tr>
                                                            <td>
                                                                <?= $data['name']; ?>
                                                            </td>
                                                            <td>
                                                                <?= $data['party'] ?? '-'; ?>
                                                            </td>
                                                            <td>
                                                                <?= $data['votes'] ?? '-'; ?>
                                                            </td>
                                                            <td>
                                                                <?= $data['percent'] ?? '-'; ?>
                                                            </td>
                                                        </tr>
                                                        <?php
                                    }
                                    $total_votes = round((100/$polling) * (float)$polled_votes, 0)??0;
                                    ?>
                                                    <tfoot>
                                                        <tr>
                                                            <td></td>
                                                            <td> Polled Votes -
                                                                <?= $polled_votes?? '-'; ?>
                                                            </td>
                                                            <td> Total Votes -
                                                                <?= $total_votes ?? '-'; ?>
                                                            </td>
                                                            <td> Polling -
                                                                <?= $polling . '%' ?? '-'; ?>
                                                            </td>
                                                        </tr>
                                                    </tfoot>
                                                    <?php
                                  } 
                                  ?>
                                                    </tbody>
                                                </table>
                                                <?php
                            } 
                          } ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php 
                    }
                    ?>

                        <!-- caste dynamics container -->
                        <?php 
                        if (count($caste_dynamics_data) > 0) {
                            ?>
                        <div class="overflow-auto report-section caste_dynamics_data_table col-md-12">
                            <div class="grid-margin stretch-card">
                                <div class="card add-row">
                                    <div class="card-body print-section">
                                        <h6 class="card-title">Caste Dynamics</h6>
                                        <div class="col-lg-12 p-4" style="border-radius:10px;">
                                            <div class="table-scroll">
                                                <table id='casteDynamicDataTable' cellspacing="0"
                                                    class='display dataTable  is-striped table-striped table'>
                                                    <thead>
                                                        <tr>
                                                            <th>Caste</th>
                                                            <th>Voters</th>
                                                            <th>Voter%</th>
                                                            <th>Caste</th>
                                                            <th>Voters</th>
                                                            <th>Voter%</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <?php
                              if (is_array($caste_dynamics_data)) {

                                $totalRows = round(count($caste_dynamics_data) / 2);
                                for ($i=0; $i < $totalRows; $i++) { 
                              ?>
                                                        <tr>
                                                            <td>
                                                                <?= $caste_dynamics_data[$i]['caste']; ?>
                                                            </td>
                                                            <td>
                                                                <?= $caste_dynamics_data[$i]['voters']; ?>
                                                            </td>
                                                            <td>
                                                                <?= $caste_dynamics_data[$i]['voter%']; ?>
                                                            </td>
                                                            <td>
                                                                <?= $caste_dynamics_data[$i + $totalRows]['caste']  ?? ''; ?>
                                                            </td>
                                                            <td>
                                                                <?= $caste_dynamics_data[$i + $totalRows]['voters'] ?? ''; ?>
                                                            </td>
                                                            <td>
                                                                <?= $caste_dynamics_data[$i + $totalRows]['voter%'] ?? ''; ?>
                                                            </td>
                                                        </tr>
                                                        <?php
                                }
                              }?>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php 
                    }
                    ?>

                        <!-- inclination container -->
                        <div
                            class="overflow-auto report-section inclination_data_table col-md-12 stretch-card grid-margin ">
                            <div class="card add-row">
                                <div class="card-body print-section">
                                    <h6 class="card-title">Party Preference</h6>
                                    <div class="col-lg-12 p-4" style="border-radius:10px;overflow:hidden;">
                                        <div class="d-flex flex-row w-100 h-100">
                                            <div class="table-scroll"
                                                style="width:100%;display:flex;flex-direction:row;justify-content:space-between">
                                                <div style="width:50%">
                                                    <div style="width:100%;" id="inclinationChartContainer"></div>
                                                </div>
                                                <div style="width:45%">
                                                    <?=$fetchReportInfo[0]['inclination_factors']?>
                                                </div>
                                            </div>

                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- ratings container -->
                        <div class="overflow-auto report-section ratings_data_table col-md-12 ">
                            <div class="grid-margin stretch-card">
                                <div class="card add-row">
                                    <div class="card-body print-section">
                                        <h6 class="card-title">PERFORMANCE OF STATE GOVT. AND MLA</h6>
                                        <div class="col-lg-12 p-4" style="border-radius:10px;">
                                            <div class="table-scroll"
                                                style="width:100%;display:flex;flex-direction:row;justify-content:space-between">
                                                <div style="width:65%">
                                                    <div style="width:100%" id="ratings-charts"></div>
                                                </div>
                                                <div style="width:30%">
                                                    <?=$fetchReportInfo[0]['rating_comment']?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- trends container -->
                        <div class="overflow-auto trends_data_table col-md-12">

                            <!-- caste table -->
                            <div class="grid-margin stretch-card report-section">
                                <div class="card add-row">
                                    <div class="card-body print-section">
                                        <div class="trend_table_heading">
                                            <h6 class="card-title">Caste</h6>
                                            <button id="caste_edit_cancel_icon"
                                                class="hidden-in-print btn btn-primary mr-2 d-none">Cancel</button>
                                            <button id="caste_edit_save_icon"
                                                class="hidden-in-print btn btn-info mr-2 d-none">Save</button>
                                            <i id="caste_edit_icon"
                                                class="hidden-in-print trends-edit-button fa fa-pencil mt-1 mr-2"></i>
                                            <!-- <div class="hidden-in-print filter">
                                                <i id="caste_filter_list_icon" class="fa fa-filter"></i>
                                                <div id="caste_filter_list" class="filter_list">
                                                    <ul>
                                                         list will fetch here dynamically 
                                                    </ul>
                                                    <button
                                                        class="filter-reset-button caste-filter-reset-button btn btn-secondry">Reset</button>
                                                </div>
                                            </div> -->
                                        </div>
                                        <div class="col-lg-12 p-4" style="border-radius:10px;">
                                            <div class="table-scroll"
                                                style="width:100%;display:flex;flex-direction:row;justify-content:space-between">
                                                <div style="width:60%">
                                                    <table id='trendsCasteDataTable' cellspacing="0"
                                                        class='caste_table dataTable display table-striped responsive'
                                                        style="width:100%">
                                                    </table>
                                                </div>
                                                <div style="width:35%">
                                                    <?=$fetchReportInfo[0]['caste_trends']?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- age group chart -->
                            <div class="grid-margin stretch-card report-section">
                                <div class="card add-row">
                                    <div class="card-body print-section">
                                        <h6 class="card-title">Age Group</h6>
                                        <div class="col-lg-12 p-4" style=" border-radius:10px;">
                                            <div class="table-scroll table-scroll-age-group"
                                                style="width:100%;display:flex;flex-direction:row;justify-content:space-between">
                                                <div style="width:50%">
                                                    <div id='trendsAgeGroupDataTable' style="width:100%"></div>
                                                </div>
                                                <div style="width:45%">
                                                    <?=$fetchReportInfo[0]['age_trends']?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- occupation table -->
                            <div class="grid-margin stretch-card report-section">
                                <div class="card add-row">
                                    <div class="card-body print-section">
                                        <h6 class="card-title">Occupation</h6>
                                        <div class="col-lg-12 p-4" style=" border-radius:10px;">
                                            <div class="table-scroll"
                                                style="width:100%;display:flex;flex-direction:row;justify-content:space-between">
                                                <div style="width:60%">
                                                    <table id='trendsOccupationDataTable' cellspacing="0"
                                                        class='occupation_table  display dataTable is-striped table-striped responsive'
                                                        style="width:100%">
                                                    </table>
                                                </div>
                                                <div style="width:35%">
                                                    <?=$fetchReportInfo[0]['occupation_trends']?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- education table -->
                            <div class="grid-margin stretch-card report-section">
                                <div class="card add-row">
                                    <div class="card-body print-section">
                                        <h6 class="card-title">Education</h6>
                                        <div class="col-lg-12 p-4" style=" border-radius:10px;">
                                            <div class="table-scroll"
                                                style="width:100%;display:flex;flex-direction:row;justify-content:space-between">
                                                <div style="width:60%">
                                                    <table id='trendsEducationDataTable' cellspacing="0"
                                                        class='education_table display dataTable is-striped table-striped responsive '
                                                        style="width:100%">
                                                    </table>
                                                </div>
                                                <div style="width:35%">
                                                    <?=$fetchReportInfo[0]['education_trends']?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>


                        </div>

                        <!-- gender container -->
                        <div class="overflow-auto report-section gender_data_table col-md-12 ">
                            <div class="grid-margin stretch-card">
                                <div class="card add-row">
                                    <div class="card-body print-section">
                                        <h6 class="card-title">PARTY WORKER ACTIVITY AND GENDER PREFERENCE</h6>
                                        <div class="col-lg-12 p-4"
                                            style="display:flex;flex-direction:row; border-radius:10px;">
                                            <div
                                                style="display:flex;align-items:center;display:flex;flex-direction:column;width:50%">
                                                <div style="width:100%" id="gender-charts"></div>
                                                <div style="border:1px solid grey; padding:1rem; width:95%">
                                                    <?=$fetchReportInfo[0]['gender_preference']?></div>
                                            </div>
                                            <div
                                                style="display:flex;align-items:center;display:flex;flex-direction:column;width:50%">
                                                <div style="width:100%" id="party-charts"></div>
                                                <div style="border:1px solid grey; padding:1rem; width:95%">
                                                    <?=$fetchReportInfo[0]['active_party_workers']?></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- swot container -->
                    <div class="overflow-auto report-section swot_data_table col-md-12 ">
                        <div class="grid-margin stretch-card">
                            <div class="card add-row">
                                <div class="card-body print-section">
                                    <h6 class="card-title">SWOT AND BOOTH CATEGORIZATION</h6>
                                    <div class="col-lg-12 p-4"
                                        style="display:flex;flex-direction:row; border-radius:10px;">
                                        <div
                                            style="display:flex;align-items:center;display:flex;flex-direction:column;width:100%">
                                            <table style="text-align:right;width:50%"
                                                class="table-striped dataTable  is-striped table responsive wrap"
                                                id="swot-table"></table>
                                            <div style="padding:1rem; width:55%;text-align:center;">
                                                <?=$fetchReportInfo[0]['swot_and_booth']?></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>


            </div>
        </div>
    </div>
    </div>
    </div>
    <?php include 'footer.php'; ?>
    <?php include 'js.php'; ?>
    </div>
    <script>
    $('#trends_radio').click(function() {
        $('.trends_data_table').removeClass('d-none');
        $('.ratings_data_table').addClass('d-none');
        $('.inclination_data_table').addClass('d-none');
    })
    $('#inclination_radio').click(function() {
        $('.inclination_data_table').removeClass('d-none');
        $('.trends_data_table').addClass('d-none');
        $('.ratings_data_table').addClass('d-none');
    })
    $('#ratings_radio').click(function() {
        $('.ratings_data_table').removeClass('d-none');
        $('.trends_data_table').addClass('d-none');
        $('.inclination_data_table').addClass('d-none');
    })
    $('#select_adjust_table').change(function() {
        if (this.value == 'Trends') {
            $('#trends-adjustment-form').css('display', 'block');
            $('#inclination-adjustment-form').css('display', 'none');
            $('#ratings-adjustment-form').css('display', 'none');
        } else if (this.value == 'Inclination') {
            $('#inclination-adjustment-form').css('display', 'block');
            $('#trends-adjustment-form').css('display', 'none');
            $('#ratings-adjustment-form').css('display', 'none');
        } else if (this.value == 'Ratings') {
            $('#ratings-adjustment-form').css('display', 'block');
            $('#inclination-adjustment-form').css('display', 'none');
            $('#trends-adjustment-form').css('display', 'none');
        }
    });
    $('#select_adjustment').change(function() {
        $('.report-input').prop('disabled', false);
        $('.report-input').prop('value', 0);
        $('#report_submit').prop('disabled', false);
        $(".report-input").removeClass("is-valid");
        $(".report-input").removeClass("is-invalid");
        document.getElementById('select_adjustment_button_lable').innerHTML = `Total: 0`;
    });
    $('#report_submit').on('click', () => {
        var caste = document.getElementById("select_adjustment").value
        var total = parseFloat(document.getElementById("select_adjustment_INC").value) + parseFloat(document
            .getElementById("select_adjustment_BJP").value) + parseFloat(document.getElementById(
            "select_adjustment_AAP").value) + parseFloat(document.getElementById("select_adjustment_Others")
            .value);
        if (total != 0) {
            event.preventDefault();
            $(".report-input").addClass("is-invalid");
            $(".report-input").removeClass("is-valid");
            alert('The total sum should be 0');
        } else {
            $(".report-input").removeClass("is-invalid");
            $(".report-input").addClass("is-valid");
            if (confirm(`Want to update Values of ${caste} ?`) == false) {
                event.preventDefault();
                $(".report-input").removeClass("is-valid");
            }
        }
    });
    $('.report-input').change(() => {
        var total = parseFloat(document.getElementById("select_adjustment_INC").value) + parseFloat(document
            .getElementById("select_adjustment_BJP").value) + parseFloat(document.getElementById(
            "select_adjustment_AAP").value) + parseFloat(document.getElementById("select_adjustment_Others")
            .value);
        document.getElementById('select_adjustment_button_lable').innerHTML = `Total: ${total}`;
        if (total != 0) {
            event.preventDefault();
            $(".report-input").addClass("is-invalid");
            $(".report-input").removeClass("is-valid");
        } else {
            $(".report-input").removeClass("is-invalid");
            $(".report-input").addClass("is-valid");
        }
    });
    // inclination
    $('#report_submit_inclination').on('click', () => {
        var total = parseFloat(document.getElementById("select_adjustment_INC_inclination").value) + parseFloat(
            document.getElementById("select_adjustment_BJP_inclination").value) + parseFloat(document
            .getElementById("select_adjustment_AAP_inclination").value) + parseFloat(document
            .getElementById("select_adjustment_Others_inclination").value);
        if (total != 0) {
            event.preventDefault();
            $(".report-input_inclination").addClass("is-invalid");
            $(".report-input_inclination").removeClass("is-valid");
            alert('The total sum should be 0');
        } else {
            $(".report-input_inclination").removeClass("is-invalid");
            $(".report-input_inclination").addClass("is-valid");
            if (confirm(`Want to update Values of Inclination?`) == false) {
                event.preventDefault();
                $(".report-input_inclination").removeClass("is-valid");
            }
        }
    });
    $('.report-input_inclination').change(() => {
        var total = parseFloat(document.getElementById("select_adjustment_INC_inclination").value) + parseFloat(
            document.getElementById("select_adjustment_BJP_inclination").value) + parseFloat(document
            .getElementById("select_adjustment_AAP_inclination").value) + parseFloat(document
            .getElementById("select_adjustment_Others_inclination").value);
        document.getElementById('select_adjustment_button_lable_inclination').innerHTML = `Total: ${total}`;
        if (total != 0) {
            event.preventDefault();
            $(".report-input_inclination").addClass("is-invalid");
            $(".report-input_inclination").removeClass("is-valid");
        } else {
            $(".report-input_inclination").removeClass("is-invalid");
            $(".report-input_inclination").addClass("is-valid");
        }
    });
    </script>

    <!-- data tables -->
    <script src="./assets/js/viewReportTableData.js"></script>

    <!-- highchart -->
    <script src="./assets/js/graph.js"></script>

    <?php
        if (isset($_POST['submit'])) {
        $updateData = [
            'caste' => $_POST["select_adjustment"],
            'INC' => $_POST["select_adjustment_INC"] == '' ? 0 : $_POST["select_adjustment_INC"],
            'BJP' => $_POST["select_adjustment_BJP"] == '' ? 0 : $_POST["select_adjustment_BJP"],
            'AAP' => $_POST["select_adjustment_AAP"] == '' ? 0 : $_POST["select_adjustment_AAP"],
            'Others' => $_POST["select_adjustment_Others"] == '' ? 0 : $_POST["select_adjustment_Others"]
        ];
        update_trends_caste_values($updateData);
        }

        if (isset($_POST['submit_inclination'])) {
        $updateData = [
            'INC' => $_POST["select_adjustment_INC_inclination"] == '' ? 0 : $_POST["select_adjustment_INC_inclination"],
            'BJP' => $_POST["select_adjustment_BJP_inclination"] == '' ? 0 : $_POST["select_adjustment_BJP_inclination"],
            'AAP' => $_POST["select_adjustment_AAP_inclination"] == '' ? 0 : $_POST["select_adjustment_AAP_inclination"],
            'Others' => $_POST["select_adjustment_Others_inclination"] == '' ? 0 : $_POST["select_adjustment_Others_inclination"]
        ];
        update_inclination_values($updateData);
        }
    ?>
</body>

</html>