function fetchId() {
    var url_string = window.location;
    var url = new URL(url_string);
    var page = url.searchParams.get("page");
    var id = url.searchParams.get("id");
    return {page, id}
}
$(document).ready(function () {
    $("#past-election").click(past_election);
    $("#ratings").click(ratings);
    $("#inclinstion").click(inclinstion);
    $("#trends").click(trends);

    function trends() {
        var {id} = fetchId();
        $("#page-content").load("./src/pages/trends.php?id=" + id, function () {
            $('.page').removeClass('active');
            $('#trends').addClass('active');
            window.history.pushState({}, '', PATH + '?page=trends&id='+id);
        });
    }

    function inclinstion() {
        var {id} = fetchId();
        $('.page').removeClass('active');
        $('#inclinstion').addClass('active');
        $("#page-content").load("./src/pages/inclinstion.php?page=inclinstion&id="+id, function () {
            google.charts.setOnLoadCallback(drawChart);
            window.history.pushState({}, '', PATH + '?page=inclinstion&id='+id);
        });
    }
    function ratings() {
        var {id} = fetchId();
        $('.page').removeClass('active');
        $('#ratings').addClass('active');
        $("#page-content").load("./src/pages/ratings.php?page=Ratings&id=" + id);
        window.history.pushState({}, '', PATH + '?page=ratings&id='+id);
    }
    function past_election() {
        var {id} = fetchId();
        $('.page').removeClass('active');
        $('#past-election').addClass('active');
        $("#page-content").load("./src/pages/past-election.php?id=" + id);
        window.history.pushState({}, '', PATH + '?page=past-election&id='+id);
    }
    setTimeout(function () {
        var {page} = fetchId();
        if (page === 'trends') {
            trends();
        }
        else if (page === 'inclinstion') {
            inclinstion();
        }
        else if (page === 'past-election') {
            past_election();
        }
        else if(page === 'ratings'){
            ratings();
        }
        else {
            $(".mainContainer").load("./dashboard/dashboard.php");
            window.history.pushState({}, '', PATH);
            window.history.go();
        }
    }, 200)
});


google.charts.load('current', { 'packages': ['corechart'] });

function drawChart() {
    var jsonData = $.ajax({
        url: "./src/database/fetch_data_chart.php",
        dataType: "json",
        async: false
    }).responseText;

    var data = new google.visualization.DataTable(jsonData);

    var chart = new google.visualization.PieChart(document.getElementById('chartContainer'));
    chart.draw(data, { width: 400, height: 240 });
}