const PATH = '/index.php';
function fetchId() {
    var url_string = window.location;
    var url = new URL(url_string);
    var page = url.searchParams.get("page");
    var id = url.searchParams.get("id");
    return { page, id }
}
$(document).ready(function () {
    $("#past-election").click(past_election);
    $("#ratings").click(ratings);
    $("#inclinstion").click(inclinstion);
    $("#trends").click(trends);

    function trends() {
        var { id } = fetchId();
        $("#page-content").load("/src/pages/trends.php?id=" + id, function () {
            $('.page').removeClass('active');
            $('#trends').addClass('active');
            document.title = localStorage.getItem("Title") + ' Report > Trends';
            window.history.pushState({}, '', PATH + '?page=trends&id=' + id);
        });
    }

    function inclinstion() {
        var { id } = fetchId();
        $('.page').removeClass('active');
        $('#inclinstion').addClass('active');
        $("#page-content").load("/src/pages/inclinstion.php?page=inclinstion&id=" + id, function () {
            document.title = localStorage.getItem("Title") + ' Report > Inclinstion';
            window.history.pushState({}, '', PATH + '?page=inclinstion&id=' + id);
            google.charts.setOnLoadCallback(drawChart);
        });
    }
    function ratings() {
        var { id } = fetchId();
        $('.page').removeClass('active');
        $('#ratings').addClass('active');
        $("#page-content").load("/src/pages/ratings.php?page=Ratings&id=" + id, function () {
            document.title = localStorage.getItem("Title") + ' Report > Ratings';
            google.charts.setOnLoadCallback(barGraph);
            window.history.pushState({}, '', PATH + '?page=ratings&id=' + id);
        });
    }
    function past_election() {
        var { id } = fetchId();
        $('.page').removeClass('active');
        $('#past-election').addClass('active');
        $("#page-content").load("/src/pages/past-election.php?id=" + id, function () {
            document.title = localStorage.getItem("Title") + ' Report > Past Election';
            window.history.pushState({}, '', PATH + '?page=past-election&id=' + id);
        });
    }
    setTimeout(function () {
        var { page } = fetchId();
        if (page === 'trends') {
            trends();
        }
        else if (page === 'inclinstion') {
            inclinstion();
        }
        else if (page === 'past-election') {
            past_election();
        }
        else if (page === 'ratings') {
            ratings();
        }
        else {
            $(".mainContainer").load("/dashboard/dashboard.php");
            window.history.pushState({}, '', PATH);
            window.history.go();
        }
    }, 200)
});

$("#logo").click(function () {
    $(".mainContainer").load("/dashboard/dashboard.php", function () {
        window.history.pushState({}, '', PATH);
        window.history.go();
    });
});


google.charts.load('current', { 'packages': ['corechart'] });

function drawChart() {
    var { id } = fetchId();
    var jsonData = $.ajax({
        url: "/src/database/fetch_data_chart.php?id=" + id,
        dataType: "json",
        data: {
            type: 'inclinstionPieChart'
        },
        async: false
    }).responseText;

    var data = new google.visualization.DataTable(jsonData);

    var chart = new google.visualization.PieChart(document.getElementById('chartContainer'));
    chart.draw(data, { width: 1000, height: 600 });
}

function defaultGraph() {
    var data = google.visualization.arrayToDataTable([
        ["Element", "Density", { role: "style" }, { role: "annotation" }],
        ["बहुत अच्छा (9-10)", 0, "grey", "0%"],
        ["अच्छा (7-8)", 0, "grey", "0%"],
        ["ठीक (5-6)", 0, "grey", "0%"],
        ["खराब (3-4)", 0, "grey", "0%"],
        ["बहुत खराब (0-2)", 0, "grey", "0%"]]
    );
    var view = new google.visualization.DataView(data);
    view.setColumns([0, 1,
        {
            calc: "stringify",
            sourceColumn: 3,
            type: "string",
            role: "annotation"
        },
        2]
    );
    var options = {
        width: 620,
        height: 400,
        bar: { groupWidth: "95%" },
        legend: { position: "none" },
    };
    var chart1 = new google.visualization.ColumnChart(document.getElementById("ratings-charts-q1"));
    var chart2 = new google.visualization.ColumnChart(document.getElementById("ratings-charts-q2"));
    var chart3 = new google.visualization.ColumnChart(document.getElementById("ratings-charts-q3"));
    chart1.draw(view, options);
    chart2.draw(view, options);
    chart3.draw(view, options);
}

function barGraph() {
    defaultGraph();
    setTimeout(loadGraph, 1);
    
}

function loadGraph() {
    var { id } = fetchId();
    // Q1
    var jsonData = $.ajax({
        url: "/src/database/fetch_data_chart.php?id=" + id,
        dataType: "json",
        data: {
            type: 'ratingBarChartQ1'
        },
        async: false
    }).responseText;

    jsonData = JSON.parse(jsonData);
    var data = google.visualization.arrayToDataTable(jsonData);
    var view1 = new google.visualization.DataView(data);
    view1.setColumns([0, 1,
        {
            calc: "stringify",
            sourceColumn: 3,
            type: "string",
            role: "annotation"
        },
        2]
    );

    // Q2
    var jsonData2 = $.ajax({
        url: "/src/database/fetch_data_chart.php?id=" + id,
        dataType: "json",
        data: {
            type: 'ratingBarChartQ2'
        },
        async: false
    }).responseText;

    jsonData2 = JSON.parse(jsonData2);
    var data2 = google.visualization.arrayToDataTable(jsonData2);
    var view2 = new google.visualization.DataView(data2);
    view2.setColumns([0, 1,
        {
            calc: "stringify",
            sourceColumn: 3,
            type: "string",
            role: "annotation"
        },
        2]
    );

    // Q3
    var jsonData3 = $.ajax({
        url: "/src/database/fetch_data_chart.php?id=" + id,
        dataType: "json",
        data: {
            type: 'ratingBarChartQ3'
        },
        async: false
    }).responseText;

    jsonData3 = JSON.parse(jsonData3);
    var data3 = google.visualization.arrayToDataTable(jsonData3);
    var view3 = new google.visualization.DataView(data3);
    view3.setColumns([0, 1,
        {
            calc: "stringify",
            sourceColumn: 3,
            type: "string",
            role: "annotation"
        },
        2]);

    var options = {
        width: 620,
        height: 400,
        bar: { groupWidth: "95%" },
        legend: { position: "none" },
    };
    var chart1 = new google.visualization.ColumnChart(document.getElementById("ratings-charts-q1"));
    var chart2 = new google.visualization.ColumnChart(document.getElementById("ratings-charts-q2"));
    var chart3 = new google.visualization.ColumnChart(document.getElementById("ratings-charts-q3"));
    chart1.draw(view1, options);
    chart2.draw(view2, options);
    chart3.draw(view3, options);
}