const PATH = '/projects/jambusar/index.php';
window.onload = () => {
    var url_string = window.location;
    var url = new URL(url_string);
    var id = url.searchParams.get("id");
    var page = url.searchParams.get("page");
    if (id) {
        loadReport(id, page);
    }
    else {
        window.history.pushState({}, '', PATH);
    }
    function loadReport(id, cpage) {
        const page = cpage || 'trends'
        $(".mainContainer").load("./report/report-page.php?page=" + page + '&id=' + id, function () { 
            loadTrends(id, page);
        });
    }
    function loadTrends(id, page) {
        window.history.pushState({}, '', PATH + '?page=' + page + '&id=' + id);
        $('.page').removeClass('active');
        $('#' + page).addClass('active');
        document.title = 'Loading...';
        $("#page-content").load("./src/pages/" + page + ".php");
    }
    $(".report").click(function () {
        loadReport($(this).data('id'));
    });
}
$(".mainContainer").load("./dashboard/dashboard.php", function () {
    $('.page').removeClass('active');
    $('#trends').addClass('active');
    $("#page-content").load("./src/pages/trends.php");
});



