<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Details;

class ListController extends Controller
{
    public function index() {
        return view('home');
    }

    public function view(Request $req) {
        $search = $req['search'] ?? "";
        if($search != "") {
            $details = Details::where('FM_NAME_EN', 'LIKE', "%$search%")->get();
        } else {
            $details = Details::limit(200)->get();
        }  
        $data = compact("details", "search");
        return view('home')->with($data);
    }

    public function edit($id){
        $details = Details::find($id);
        if(is_null($details)){
            return redirect('/home');
        } else {
            $data = compact('details');
            return view('edit')->with($data);
        }
    }

    public function update($id, Request $req) {
        $details = Details::find($id);
        $details->FM_NAME_EN = $req['firstname'];
        $details->LASTNAME_EN = $req['lastName'];
        $details->GENDER = $req['gender'];
        $details->MOB = $req['mobileNumber'];
        $details->save();

        return redirect('/home');
    }
}
