<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddFieldsToUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('users', function (Blueprint $table) {
            $table->string('username')->after('name')->unique();
            $table->boolean('is_donated')->after('username')->default(0);
            $table->string('referal_user')->after('is_donated')->nullable();
            $table->float('age')->after('referal_user')->nullable();
            $table->string('blood_group')->after('age')->nullable();
            $table->string('district')->after('blood_group')->nullable();
            $table->string('assembly')->after('district')->nullable();
            $table->string('city_village_nanme')->after('assembly')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('users', function (Blueprint $table) {
            //
        });
    }
}
