<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    
    <link rel="stylesheet" href="https://fonts.googleapis.com/icon?family=Material+Icons">
    <title>Edit</title>
    <link rel="stylesheet" href="../../public/assets/css/styles.css" />
    <style>
        .material-symbols-outlined {
            font-variation-settings: 'FILL' 0, 'wght' 400, 'GRAD' 0, 'opsz' 48
        }
    </style>
</head>

<body>
    <header>
        <div class="back">
            <a href="{{url('/home')}}" style="text-decoration: none;">&larr;</a>
        </div>
        <div class="epicNumber">
            VoterID no. <br /><strong>{{$details->EPIC_NO}}</strong>
        </div>
    </header>
    <main>
        <section class="profile-picture">
            @if($details->GENDER == 'M')
                <img class="profile-picture-img" src="../../public/assets/images/img.jpg" alt="">    
            @else
                <img class="profile-picture-img" src="../../public/assets/images/img1.png" alt="">
            @endif
            
            <div class="add-camera"><img src="../../public/assets/images/camera.png" alt=""></div>
            change profile picture
        </section>
        <section class="form">
            <form action="{{url('/update')}}/{{$details->id}}" method="post">
                @csrf
                <div class="input-div">
                    <label for="firstName">First Name</label>
                    <input type="text" name="firstname" id="firstName" placeholder="John" value="{{$details->FM_NAME_EN}}">
                </div>
                <div class="input-div">
                    <label for="lastName">Last Name</label>
                    <input type="text" name="lastname" id="lastName" placeholder="Doe" value="{{$details->LASTNAME_EN}}">
                </div>
                <div class="input-div">
                    <label for="DOB">Date Of Birth</label>
                    <input type="date" name="DOB" id="DOB" placeholder="DD/MM/YYYY" value="{{$details->DOB}}">
                </div>
                <div class="input-div">
                    <label for="Gender">Gender</label>
                    <select name="gender" id="Gender">
                        <option value="" selected disabled>Select your gender</option>
                        <option value="M" {{$details->GENDER == "M" ? "selected" : ""}}>Male</option>
                        <option value="F" {{$details->GENDER == "F" ? "selected" : ""}}>Female</option>
                        <option value="O" {{$details->GENDER == "O" ? "selected" : ""}}>Other</option>
                    </select>
                </div>
                <div class="input-div">
                    <label for="Occupation">Occupation</label>
                    <select name="occupation" id="Occupation">
                        <option value="" selected disabled>Select your occupation</option>
                        <option value="Teacher">Teacher</option>
                        <option value="Officer">Officer</option>
                    </select>
                </div>
                <div class="input-div">
                    <label for="Caste">Caste</label>
                    <select name="caste" id="Caste">
                        <option value="" selected disabled>Select your caste</option>
                        <option value="Jain">Jain</option>
                        <option value="Hindu">Hindu</option>
                        <option value="Muslim">Muslim</option>
                    </select>
                </div>
                <div class="input-div">
                    <label for="address">Address</label>
                    <textarea name="address" id="address" rows="3" cols="40">{{$details->HOUSE_MO}}, {{$details->SECTION_NAME_EN}}</textarea>
                </div>
                <div class="input-div">
                    <label for="mobileNumber">Mobile No.</label>
                    <input name="mobileNumber" id="mobileNumber" type="tel" value="{{$details->MOB}}">
                </div>
                <div class="input-div">
                    <label for="whatsappNumber">WhatsApp No.</label>
                    <input name="whatsappNumber" id="whatsappNumber" type="tel" value="{{$details->MOB}}">
                </div>

                <div class="input-div">
                    <label for="Party">Party</label>
                    <select name="party" id="Party">
                        <option value="" selected disabled>Select your Party</option>
                        <option value="BJP">BJP</option>
                        <option value="INC">INC</option>
                        <option value="JDS">JDS</option>
                        <option value="AAP">AAP</option>
                        <option value="AIMIM">AIMIM</option>
                        <option value="SDPI">SDPI</option>
                        <option value="BSP">BSP</option>
                        <option value="Others">Others</option>
                    </select>
                </div>
                <div class="more-info">
                    <a href="#">more info</a>
                </div>
                <div class="submit">
                    <button>Add members</button>
                    <button type="submit">Update</button>
                </div>
            </form>
        </section>
    </main>
  
</body>

</html>