<!doctype html>
<html>
    <head>
        <meta charset="utf-8" />
        <meta name="viewport" content="width=device-width, initial-scale=1" />
        <title>Chittapur</title>

        <!-- Stylesheet starts -->
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha3/dist/css/bootstrap.min.css" />
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.4/font/bootstrap-icons.css">
        <link rel="stylesheet" href="public/assets/css/main.css" />
        <!-- End of Stylesheet -->
    </head>

    <body style="max-width:700px;margin: 0px auto;">
        <!-- Header Section starts -->
        <header class="bg-white position-sticky top-0 left-0" style="z-index:100;">
          <!-- Navigation menu starts -->
          <nav class="navbar navbar-expand-lg bg-white">
              <div class="container-fluid">
                
                <button class="navbar-toggler border-0" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                  <span class="navbar-toggler-icon"></span>
                </button>
                
                <div class="text-center">
                    <div class="booth-no">
                        <strong>Booth No: {{$details[0]['PART_NO']}}</strong><br />
                    </div>
                    <div class="address text-center">
                        {{$details[0]['VILLAGE_NAME_EN']}}, <span class="text-uppercase">{{$details[0]['GP_NAME']}},</span> <br />{{$details[0]['Block_NAME_EN']}}
                    </div>
                </div>

                <button class="btn btn-primary bg-transparent border-0" type="button">
                  <i class="bi bi-translate text-dark fs-2"></i>
                </button>
              </div>
            </nav>
          <!-- End of Navigation menu -->

          <!-- Secondary menu starts -->
          <div class="container-fluid pt-2">
            <div class="row">
                <div class="col-10">
                    <form>
                        <input type="search" id="search" name="search" placeholder="Search your name ..." class="form-control rounded-4" value="{{$search}}" />
                        {{-- <button type="submit" class="btn btn-primary">Search</button> --}}
                    </form>
                </div>

                <div class="col-2">
                    <button type="button" class="btn btn-primary border-0 bg-transparent">
                        <i class="bi bi-sliders text-black"></i>
                    </button>
                </div>
            </div>
          </div>
        <!-- End of secondary menu -->
        </header>
        <!-- End of Header Section -->

        <!--<hr />-->
        
        <main class="bg-white">
          <!-- Information List starts -->
          <section class="container-fluid pt-3">
                    @foreach($details as $data)
                    <div class="row py-2">
                      
                      <div class="col-12">
                        <small class="text-muted ps-4 float-start">{{$data->SRNO}}</small>
                        <small class="text-muted float-end">{{$data->GENDER == 'M' ? "Male" : "Female"}}/{{$data->AGE}} | {{$data->EPIC_NO}}</small>
                      </div>
                    </div>

                    <div class='row'>
                      <div class='col-4 p-0 text-center'>
                          @if($data->GENDER == 'M')
                          <img src='public/assets/images/img.jpg' alt='img' class='img-fluid w-50 rounded-circle border-1'/>
                          @else
                          <img src='public/assets/images/img1.png' alt='img' class='img-fluid w-50 rounded-circle border-1'/>
                          @endif
                      </div>
                      
                      <div class='col-8 text-start'>
                        <h5 class="text-uppercase">{{$data->FM_NAME_EN}} {{$data->LASTNAME_EN}}</h5>
                        <p>Relation: <span class="text-uppercase">{{$data->RLN_FM_NM_EN}} {{$data->RLN_L_NM_EN}}</span><br />{{$data->HOUSE_MO}}, {{$data->Section_Name_Final}}</p>
                      </div>
                      
                      <div class="p-0 mb-3 d-flex flex-row flex-wrap gap-3 justify-content-center">
                          <div>
                              <a href="tel: {{ $data->MOB }}" class="{{$data->MOB ==''? 'border border-secondary': 'btn-outline-success'}} align-items-center rounded-5 p-0 ps-3 d-flex justify-content-between text-decoration-none btn" style="height: 2.5;">
                                  <span class="mobile-number px-2 {{$data->MOB ==''? 'not-available': ''}}">{{$data->MOB ==''? 'Not available':$data->MOB}}</span>
                                  <i class="bi bi-telephone fs-6 text-white rounded-circle p-2 {{$data->MOB ==''? 'bg-secondary': 'bg-success'}}" style="width: 2.5rem; height: 2.5rem;"></i>
                              </a>
                          </div>
                          
                          <div>
                              <a href="{{url('/home/edit')}}/{{$data->id}}" class="align-items-center p-0 ps-3 rounded-5 d-flex justify-content-between text-decoration-none btn btn-outline-warning">
                                  <span class="px-2">Update Info</span>
                                  <i class='bi bi-pencil-square fs-6 bg-warning text-white rounded-circle p-2'  style="width: 2.5rem; height: 2.5rem;"></i>
                              </a>
                          </div>
                      </div>

                      <!--<div class="row">-->
                      <!--  <div class="col-6">-->
                      <!--    <a class="text-decoration-none">-->
                      <!--        <button type="button" class="btn btn-outline-success d-block" href='tel: {{$data->MOB}}'>&nbsp; {{$data->MOB}}<i class='bi bi-telephone text-success fs-6'></i></a>-->
                      <!--  </div>-->

                      <!--  <div class="col-6">-->
                      <!--    <a class="text-decoration-none btn btn-outline-dark d-block" style="border-color: orange; color: orange;" href="{{url('/edit')}}/{{$data->id}}"><i class='bi bi-pencil-square fs-6' style="color: orange;"></i> Update Info</a>-->
                      <!--  </div>-->
                      <!--</div>-->
                    </div>
                    <hr class="divider" />
                    @endforeach
          </section>
          <!-- End of Information List -->
        </main>

        <!-- Scripting starts -->
        <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.4/jquery.min.js" integrity="sha512-pumBsjNRGGqkPzKHndZMaAG+bir374sORyzM3uulLV14lN5LyykqNk8eEeUlUkB3U0M4FApyaHraT65ihJhDpQ==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
        <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha3/dist/js/bootstrap.bundle.min.js"></script>
        <script src="public/assets/js/main.js"></script>
        <!-- End of Scripting -->
    </body>
</html>